/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
	//logo
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
		
	//rastro de migas
	$("#ab18aBoletinesWar_migas").rup_breadCrumb({
		breadCrumb: {
			"monitor":{
				i18nCaption : "monitor",
				url: "monitor",
				"detalle":{
					i18nCaption : "detallePeticion"
				}
			},
			"incoherencias":{
				i18nCaption : "incoherencias",
				url: "incoherencias",
				"detalle":{
					i18nCaption : "detallePeticion"
				}
			},
			"aplicacion":{
				"mantenimiento":{
					i18nCaption : "Mto. Aplicación Invocante"
				}
			},
			
			"boletin":{
				"mantenimiento":{
					i18nCaption : "Mto. Boletines"
				}
			},
			
			"merrores":{
				"mantenimiento":{
					i18nCaption : "Mto. Errores Aplicación"
				}
			},
			
			"estadoPeticion":{
				"mantenimiento":{
					i18nCaption : "Mto. Estados"
				}
			},
			"tipoEnvio":{
				"mantenimiento":{
					i18nCaption : "Mto. Tipos de Envío"
				}
			}
			
		},
		initURL: "ab18aBoletinesWar",
		logOutUrl: $.rup.CTX_PATH+"logout"
	});
	
	/*SELECTOR DE IDIOMA
	 * configuramos el selector de idioma
	 * En función del idioma actual, habilito el link correspondiente
	 */
	if($.rup.lang=="es")
	{
		$("#aIdiomaEU").attr("href",$.rup.CTX_PATH + "?locale=eu");
		$("#aIdiomaES").addClass("idiomaActual");
	}else{
		$("#aIdiomaES").attr("href",$.rup.CTX_PATH + "?locale=es");
		$("#aIdiomaEU").addClass("idiomaActual");
	}
	
	//menu
	$("#ab18aBoletinesWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal')
	});
	if ($.rup.LAYOUT === "mixto") {
		$("#ab18aBoletinesWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	
	//pie
	$(".footer [title]").rup_tooltip();
	
	
});

/*
 * Función que limpia todos los campos de un formulario
 */
function fncLimpiarCampos(elemento)
{
	$(elemento).find(":text, textarea, :file, :password").val("");
	$(elemento).find(":checkbox, :radio").attr("checked",""); 
	$(elemento).find(".rup_combo").rup_combo("clear"); 
}

function blockUI_Cargando()
{
	 $.blockUI({
		   message: '<img src="' + $.rup.RUP + '/basic-theme/images/rup.ajaxLoader.gif" style="position:absolute;top:12px;left:15px;z-index:100000" alt="' + $.rup.i18n.base.rup_blockUI.cargando + '" ><h3 class="loading">' + $.rup.i18n.base.rup_blockUI.cargando + '...' + '</h3>',
		   baseZ: 2000 //para que siempre salga por encima de todas las ventanas
		});    
}

/*
 ************************************************************************************************************************** 
 ******************************************* INICIO CONTROL DE CAMBIOS ******************************************************* 
 ************************************************************************************************************************** 
 */

/*
 * Variable global para control de cambios
 * gCambios = 0 --> no hay cambios
 * gCambios = 1 --> si hay cambios
 */ 
var gCambios = 0;
var gCambiosModal = 0;

/*
 * Método que asigna a todos los controles que contiene un control el evento change
 * en dicho evento se llama al método que controla que se han realizado cambios.
 * 
 * Parametro pstrId --> Id del control (form, div, etc) que contiene los controles 
 * 						a los que queremos realizar el control de cambios
 * Parametro pblnModal --> Cuando su valor es "true", indica que estamos realizado el
 * 						control de cambios en un popup 
 */
function fncAplicarGestionCambios(pstrId, pblnModal)
{
	if (pblnModal){
		$("#" + pstrId).find(":text, :checkbox, :radio, textarea, :password").change(function(){fncHayCambiosModal();});		
		$("#" + pstrId).find(":file").attr("onchange","fncHayCambiosModal();");
	}else{
		$("#" + pstrId).find(":text, :checkbox, :radio, textarea, :password").change(function(){fncHayCambios();});
		$("#" + pstrId).find(":file").attr("onchange","fncHayCambios();");
	}
	
	
	fncResetearCambios(pblnModal);
}

/*
 * Function que comprueba si se han realizado cambios en la pantalla.
 * 
 *  Parametro pstrFuncionSiOk --> Método que se quiere lanzar cuando pulsa "Aceptar"
 *  							  en el mensaje de confirmación
 */
function fncConfirmarCambios(pstrFuncionSiOk, pblnModal)
{
	if (fncComprobarSiCambios(pblnModal))
	{
		$.rup_messages("msgConfirm", {
			title: $.rup.i18n.app.mensajes.alert.confirma_pierde_cambios_titulo,
			message: $.rup.i18n.app.mensajes.alert.confirma_pierde_cambios,
			OKFunction: function(){
				fncResetearCambios(pblnModal); //reseteo el control de cambios
				if (pstrFuncionSiOk != "" && pstrFuncionSiOk != null) eval(pstrFuncionSiOk);
			}
		});
	}
}

/*
 * Método que devuelve un true o un false en función de si se han realizado cambios o no
 * 
 * Parametro pblnModal --> En caso de ser "true", comprueba los cambios de un popup
 */
function fncComprobarSiCambios(pblnModal)
{
	if (pblnModal){
		if (gCambiosModal == 0)
		{
			return false;
		}else{
			return true;
		}
	}else{		
		if (gCambios == 0)
		{
			return false;
		}else{
			return true;
		}
	}
}

/*
 * Método para controlar cuando se han realizado cambios. 
 * Se lanza en el evento change de los controles
 * 
 * Además incluye en evento "beforeunload" al objeto window para que pregunte antes de cerrar la ventana
 */
function fncHayCambios()
{
	gCambios = 1;
	
	
	//defino el contro de cambios antes de salir de cerrar o salir de una pantalla
	//aparecerá un mensaje de confirmación antes de poder cerrar la ventana
	$(window).on("beforeunload",function(){
		return $.rup.i18n.app.mensajes.alert.confirma_cierra_ventana;	
	});
}

/*
 * Método para controlar cuando se han realizado cambios. 
 * Se lanza en el evento change de los controles
 * 
 * Además incluye en evento "beforeunload" al objeto window para que pregunte antes de cerrar la ventana
 */
function fncHayCambiosModal()
{
	gCambiosModal = 1;
	
	
	//defino el contro de cambios antes de salir de cerrar o salir de una pantalla
	//aparecerá un mensaje de confirmación antes de poder cerrar la ventana
	$(window).on("beforeunload",function(){
		return $.rup.i18n.app.mensajes.alert.confirma_cierra_ventana;	
	});
}

/*
 * Método para resetear el control de cambios
 * 
 * Además elimina en evento "beforeunload" del objeto window, en caso de no existir cambios sin guardar
 */
function fncResetearCambios(pblnModal)
{
	
	if (pblnModal){
		gCambiosModal = 0;
	}else{
		gCambios = 0;
	}
	
	//si no hay ningún cambio pendiente de guardar
	if (gCambios == 0 && gCambiosModal == 0){		
		//Elimino el contro de cambios antes de salir de cerrar o salir de una pantalla
		$(window).off("beforeunload");
	}
}
/*
 ************************************************************************************************************************** 
 ******************************************* FIN CONTROL DE CAMBIOS ******************************************************* 
 ************************************************************************************************************************** 
 */

/*
 * Metodo para ocultar los iconos y estilos de los validadores al abrir un popup
 * Parametro pstrIdRupMensajes --> Id del objeto RupMensajes que contiene el popup. Hay que pasarlo acompañado de la #
 */
function fncOcultarValidaciones(pstrIdRupMensajes)
{
	if (pstrIdRupMensajes)
	{
		//Eliminamos el dialogo por si tiene iconos de validación de visitas anteriores o mensajes
		$(pstrIdRupMensajes).rup_feedback("close");
	}
	//Ocultamos los iconos de validación si hubiera alguno visible.
	$(".rup-maint_validateIcon").hide();	
	$(".error").removeClass("error");
}